/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.datamodels.v2_1.DataModelConstants;
import com.roguewave.chart.drawables.device.v2_1.DeviceLines;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.overlay.core.v2_1.Scaler;
import com.roguewave.chart.overlay.overlays.v2_1.MarkerFactory;
import java.awt.Color;

public class LineChartOverlay
implements ChartOverlay,
DataModelConstants,
ScaleConstants {
    public static final int SKIP = 0;
    public static final int SPAN = 1;
    int dataRow_;
    Color color_;
    boolean scale_;
    int mode_;
    MarkerFactory markerFactory_;

    public LineChartOverlay(int dataRow, Color color, boolean scale) {
        this(dataRow, color, scale, false, null);
    }

    public LineChartOverlay(int dataRow, Color color, boolean scale, boolean skip, MarkerFactory factory) {
        this.dataRow_ = this.dataRow_ < 0 ? 0 : dataRow;
        this.color_ = color;
        this.scale_ = scale;
        this.mode_ = skip ? 0 : 1;
        this.markerFactory_ = factory;
    }

    public int getItemWidth() {
        return this.markerFactory_ != null ? this.markerFactory_.markerWidth() : 1;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        if (data.getRowCount() <= this.dataRow_) {
            return;
        }
        ParameterCalculator params = this.scale_ ? params1 : params2;
        Scaler scaler = params.getScaler();
        int dataPoints = data.getColumnCount();
        int xi = left + offset;
        double rawValue = data.getValue(this.dataRow_, 0);
        if (dataPoints < 2) {
            if (dataPoints == 1 && this.markerFactory_ != null) {
                int y = base - scaler.scale(rawValue);
                Drawable marker = this.markerFactory_.makeMarker(xi, y);
                chartGraphics.add2DDrawable(marker);
            }
            return;
        }
        int[] x1 = new int[dataPoints - 1];
        int[] x2 = new int[dataPoints - 1];
        int[] y1 = new int[dataPoints - 1];
        int[] y2 = new int[dataPoints - 1];
        Drawable[] markers = null;
        if (this.markerFactory_ != null) {
            markers = new Drawable[dataPoints + 1];
        }
        double lastValue = Double.NEGATIVE_INFINITY;
        int lastxi = 0;
        int mi = 0;
        int finalIndex = -1;
        for (int i = 0; i < dataPoints - 1; ++i) {
            if (rawValue == Double.NEGATIVE_INFINITY) {
                if (lastValue == Double.NEGATIVE_INFINITY || this.mode_ == 0) {
                    y2[i] = -10000;
                    x2[i] = -10000;
                    y1[i] = -10000;
                    x1[i] = -10000;
                    rawValue = data.getValue(this.dataRow_, i + 1);
                    xi += columnWidth;
                    continue;
                }
                x1[i] = lastxi;
                y1[i] = base - scaler.scale(lastValue);
            } else {
                lastValue = rawValue;
                lastxi = xi;
                x1[i] = xi;
                y1[i] = base - scaler.scale(rawValue);
                if (this.markerFactory_ != null) {
                    markers[mi++] = this.markerFactory_.makeMarker(x1[i], y1[i]);
                }
            }
            xi += columnWidth;
            rawValue = data.getValue(this.dataRow_, i + 1);
            if (rawValue == Double.NEGATIVE_INFINITY) {
                y2[i] = -10000;
                x2[i] = -10000;
                y1[i] = -10000;
                x1[i] = -10000;
                continue;
            }
            finalIndex = i;
            x2[i] = xi;
            y2[i] = base - scaler.scale(rawValue);
        }
        chartGraphics.add2DDrawable(new DeviceLines(x1, y1, x2, y2, this.color_));
        if (this.markerFactory_ != null) {
            if (finalIndex != -1) {
                markers[mi++] = this.markerFactory_.makeMarker(x2[finalIndex], y2[finalIndex]);
            }
            for (int i = 0; i < mi; ++i) {
                chartGraphics.add2DDrawable(markers[i]);
            }
        }
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public int getDataRow() {
        return this.dataRow_;
    }

    public void setDataRow(int dataRow) {
        if (dataRow >= 0) {
            this.dataRow_ = dataRow;
        }
    }

    public MarkerFactory getMarkerFactory() {
        return this.markerFactory_;
    }

    public void setMarkerFactory(MarkerFactory factory) {
        this.markerFactory_ = factory;
    }

    public int getMissingDataMode() {
        return this.mode_;
    }

    public void setMissingDataMode(int mode) {
        this.mode_ = mode;
    }

    public boolean getScale() {
        return this.scale_;
    }

    public void setScale(boolean scale) {
        this.scale_ = scale;
    }
}

